using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var moves = new List<(int x, int y)>();
        
        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            int x = int.Parse(parts[0]);
            int y = int.Parse(parts[1]);
            moves.Add((x, y));
        }

        Func<int, int, double> distance = (x, y) => Math.Sqrt(x * x + y * y);

        int X = 0, Y = 0;
        List<int> chosenMoves = new List<int>();

        double maxDist = 0;
        foreach (var move in moves)
        {
            double dist = distance(X + move.x, Y + move.y);
            if (dist > maxDist)
            {
                maxDist = dist;
                chosenMoves.Clear();
                chosenMoves.Add(moves.IndexOf(move) + 1);  
                X += move.x;
                Y += move.y;
            }
        }

        Console.WriteLine(chosenMoves.Count);
        foreach (var move in chosenMoves)
        {
            Console.Write(move + " ");
        }
    }
}